/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.histogram;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.api.Utils;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongFunction;

public final class BucketTimer
implements Timer {
    private final Registry registry;
    private final Id id;
    private final LongFunction<String> f;
    private final ConcurrentHashMap<String, Timer> timers;
    private final Function<String, Timer> timerFactory;

    public static BucketTimer get(Registry registry, Id id, LongFunction<String> f) {
        return new BucketTimer(registry, id, f);
    }

    BucketTimer(Registry registry, Id id, LongFunction<String> f) {
        this.registry = registry;
        this.id = id;
        this.f = f;
        this.timers = new ConcurrentHashMap();
        this.timerFactory = k -> registry.timer(id.withTag("bucket", (String)k));
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public Iterable<Measurement> measure() {
        return Collections.emptyList();
    }

    @Override
    public boolean hasExpired() {
        return false;
    }

    @Override
    public Clock clock() {
        return this.registry.clock();
    }

    @Override
    public void record(long amount, TimeUnit unit) {
        long nanos = unit.toNanos(amount);
        this.timer(this.f.apply(nanos)).record(amount, unit);
    }

    Timer timer(String bucket) {
        return Utils.computeIfAbsent(this.timers, bucket, this.timerFactory);
    }

    @Override
    public long count() {
        return 0L;
    }

    @Override
    public long totalTime() {
        return 0L;
    }
}

