/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Meter;
import com.netflix.spectator.api.TimerBatchUpdater;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntSupplier;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongSupplier;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleBiFunction;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongBiFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;

public interface Timer
extends Meter {
    default public Clock clock() {
        return Clock.SYSTEM;
    }

    public void record(long var1, TimeUnit var3);

    default public void record(Duration amount) {
        this.record(amount.toNanos(), TimeUnit.NANOSECONDS);
    }

    default public void record(long[] amounts, int n, TimeUnit unit) {
        int limit = Math.min(amounts.length, n);
        for (int i = 0; i < limit; ++i) {
            this.record(amounts[i], unit);
        }
    }

    default public void record(Duration[] amounts, int n) {
        int limit = Math.min(amounts.length, n);
        for (int i = 0; i < limit; ++i) {
            this.record(amounts[i]);
        }
    }

    @Deprecated
    default public <T> T record(Callable<T> f) throws Exception {
        return this.recordCallable(f);
    }

    @Deprecated
    default public void record(Runnable f) {
        this.recordRunnable(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T recordCallable(Callable<T> f) throws Exception {
        Clock clock = this.clock();
        long s = clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void recordRunnable(Runnable f) {
        Clock clock = this.clock();
        long s = clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public <T> T recordSupplier(Supplier<T> f) {
        Clock clock = this.clock();
        long s = clock.monotonicTime();
        try {
            T t = f.get();
            return t;
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public boolean recordBooleanSupplier(BooleanSupplier f) {
        Clock clock = this.clock();
        long s = clock.monotonicTime();
        try {
            boolean bl = f.getAsBoolean();
            return bl;
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public double recordDoubleSupplier(DoubleSupplier f) {
        Clock clock = this.clock();
        long s = clock.monotonicTime();
        try {
            double d = f.getAsDouble();
            return d;
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public int recordIntSupplier(IntSupplier f) {
        Clock clock = this.clock();
        long s = clock.monotonicTime();
        try {
            int n = f.getAsInt();
            return n;
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public long recordLongSupplier(LongSupplier f) {
        Clock clock = this.clock();
        long s = clock.monotonicTime();
        try {
            long l = f.getAsLong();
            return l;
        }
        finally {
            long e = clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    default public <V> Callable<V> wrapCallable(Callable<V> f) {
        return () -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                Object v = f.call();
                return v;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public Runnable wrapRunnable(Runnable f) {
        return () -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                f.run();
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T, U> BiConsumer<T, U> wrapBiConsumer(BiConsumer<T, U> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                f.accept(t, u);
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T, U, R> BiFunction<T, U, R> wrapBiFunction(BiFunction<T, U, R> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                Object r = f.apply(t, u);
                return r;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> BinaryOperator<T> wrapBinaryOperator(BinaryOperator<T> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                Object r = f.apply(t, u);
                return r;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T, U> BiPredicate<T, U> wrapBiPredicate(BiPredicate<T, U> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                boolean bl = f.test(t, u);
                return bl;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public BooleanSupplier wrapBooleanSupplier(BooleanSupplier f) {
        return () -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                boolean bl = f.getAsBoolean();
                return bl;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> Consumer<T> wrapConsumer(Consumer<T> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                f.accept(t);
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public DoubleBinaryOperator wrapDoubleBinaryOperator(DoubleBinaryOperator f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                double d = f.applyAsDouble(t, u);
                return d;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public DoubleConsumer wrapDoubleConsumer(DoubleConsumer f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                f.accept(t);
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <R> DoubleFunction<R> wrapDoubleFunction(DoubleFunction<R> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                Object r = f.apply(t);
                return r;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public DoublePredicate wrapDoublePredicate(DoublePredicate f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                boolean bl = f.test(t);
                return bl;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public DoubleSupplier wrapDoubleSupplier(DoubleSupplier f) {
        return () -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                double d = f.getAsDouble();
                return d;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public DoubleToIntFunction wrapDoubleToIntFunction(DoubleToIntFunction f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                int n = f.applyAsInt(t);
                return n;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public DoubleToLongFunction wrapDoubleToLongFunction(DoubleToLongFunction f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                long l = f.applyAsLong(t);
                return l;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public DoubleUnaryOperator wrapDoubleUnaryOperator(DoubleUnaryOperator f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                double d = f.applyAsDouble(t);
                return d;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T, R> Function<T, R> wrapFunction(Function<T, R> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                Object r = f.apply(t);
                return r;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public IntBinaryOperator wrapIntBinaryOperator(IntBinaryOperator f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                int n = f.applyAsInt(t, u);
                return n;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public IntConsumer wrapIntConsumer(IntConsumer f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                f.accept(t);
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <R> IntFunction<R> wrapIntFunction(IntFunction<R> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                Object r = f.apply(t);
                return r;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public IntPredicate wrapIntPredicate(IntPredicate f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                boolean bl = f.test(t);
                return bl;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public IntSupplier wrapIntSupplier(IntSupplier f) {
        return () -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                int n = f.getAsInt();
                return n;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public IntToDoubleFunction wrapIntToDoubleFunction(IntToDoubleFunction f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                double d = f.applyAsDouble(t);
                return d;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public IntToLongFunction wrapIntToLongFunction(IntToLongFunction f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                long l = f.applyAsLong(t);
                return l;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public IntUnaryOperator wrapIntUnaryOperator(IntUnaryOperator f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                int n = f.applyAsInt(t);
                return n;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public LongBinaryOperator wrapLongBinaryOperator(LongBinaryOperator f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                long l = f.applyAsLong(t, u);
                return l;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public LongConsumer wrapLongConsumer(LongConsumer f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                f.accept(t);
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <R> LongFunction<R> wrapLongFunction(LongFunction<R> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                Object r = f.apply(t);
                return r;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public LongPredicate wrapLongPredicate(LongPredicate f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                boolean bl = f.test(t);
                return bl;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public LongSupplier wrapLongSupplier(LongSupplier f) {
        return () -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                long l = f.getAsLong();
                return l;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public LongToIntFunction wrapLongToIntFunction(LongToIntFunction f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                int n = f.applyAsInt(t);
                return n;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public LongToDoubleFunction wrapLongToDoubleFunction(LongToDoubleFunction f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                double d = f.applyAsDouble(t);
                return d;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public LongUnaryOperator wrapLongUnaryOperator(LongUnaryOperator f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                long l = f.applyAsLong(t);
                return l;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> ObjDoubleConsumer<T> wrapObjDoubleConsumer(ObjDoubleConsumer<T> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                f.accept(t, u);
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> ObjIntConsumer<T> wrapObjIntConsumer(ObjIntConsumer<T> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                f.accept(t, u);
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> ObjLongConsumer<T> wrapObjLongConsumer(ObjLongConsumer<T> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                f.accept(t, u);
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> Predicate<T> wrapPredicate(Predicate<T> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                boolean bl = f.test(t);
                return bl;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> Supplier<T> wrapSupplier(Supplier<T> f) {
        return () -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                Object t = f.get();
                return t;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T, U> ToDoubleBiFunction<T, U> wrapToDoubleBiFunction(ToDoubleBiFunction<T, U> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                double d = f.applyAsDouble(t, u);
                return d;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> ToDoubleFunction<T> wrapToDoubleFunction(ToDoubleFunction<T> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                double d = f.applyAsDouble(t);
                return d;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T, U> ToIntBiFunction<T, U> wrapToIntBiFunction(ToIntBiFunction<T, U> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                int n = f.applyAsInt(t, u);
                return n;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> ToIntFunction<T> wrapToIntFunction(ToIntFunction<T> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                int n = f.applyAsInt(t);
                return n;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T, U> ToLongBiFunction<T, U> wrapToLongBiFunction(ToLongBiFunction<T, U> f) {
        return (t, u) -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                long l = f.applyAsLong(t, u);
                return l;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> ToLongFunction<T> wrapToLongFunction(ToLongFunction<T> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                long l = f.applyAsLong(t);
                return l;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    default public <T> UnaryOperator<T> wrapUnaryOperator(UnaryOperator<T> f) {
        return t -> {
            Clock clock = this.clock();
            long s = clock.monotonicTime();
            try {
                Object r = f.apply(t);
                return r;
            }
            finally {
                long e = clock.monotonicTime();
                this.record(e - s, TimeUnit.NANOSECONDS);
            }
        };
    }

    public long count();

    public long totalTime();

    default public BatchUpdater batchUpdater(int batchSize) {
        return new TimerBatchUpdater(this, batchSize);
    }

    public static interface BatchUpdater
    extends AutoCloseable {
        public void record(long var1, TimeUnit var3);

        default public void record(Duration amount) {
            this.record(amount.toNanos(), TimeUnit.NANOSECONDS);
        }

        public void flush();
    }
}

