/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.math.BigDecimal;
import java.util.List;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.vcard.AbstractFactory;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.PropertyFactory;

public final class Geo
extends Property {
    private static final long serialVersionUID = 1533383111522264554L;
    private static final String DELIMITER = ";";
    private final BigDecimal latitude;
    private final BigDecimal longitude;

    public Geo(BigDecimal latitude, BigDecimal longitude) {
        super(Property.Id.GEO);
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Geo(List<Parameter> params, String value) {
        this(null, params, value);
    }

    public Geo(Group group, List<Parameter> params, String value) {
        super(group, Property.Id.GEO, params);
        String[] components = null;
        components = CompatibilityHints.isHintEnabled((String)"ical4j.parsing.relaxed") ? value.split("[;,]") : value.split(DELIMITER);
        this.latitude = new BigDecimal(components[0]);
        this.longitude = new BigDecimal(components[1]);
    }

    @Override
    public String getValue() {
        return this.getLatitude() + DELIMITER + this.getLongitude();
    }

    public BigDecimal getLatitude() {
        return this.latitude;
    }

    public BigDecimal getLongitude() {
        return this.longitude;
    }

    @Override
    public void validate() throws ValidationException {
        this.assertParametersEmpty();
    }

    public static class Factory
    extends AbstractFactory
    implements PropertyFactory<Geo> {
        public Factory() {
            super(Property.Id.GEO.toString());
        }

        @Override
        public Geo createProperty(List<Parameter> params, String value) {
            return new Geo(params, value);
        }

        @Override
        public Geo createProperty(Group group, List<Parameter> params, String value) {
            return new Geo(group, params, value);
        }
    }
}

