/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class DirEntryGwtSerDer implements GwtSerDer<net.bluemind.directory.api.DirEntry> {

	private net.bluemind.directory.api.gwt.serder.BaseDirEntryGwtSerDer parent = new  net.bluemind.directory.api.gwt.serder.BaseDirEntryGwtSerDer();
	public DirEntryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.directory.api.DirEntry deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.directory.api.DirEntry ret = new net.bluemind.directory.api.DirEntry();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.directory.api.DirEntry ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue pathJSON = json.get("path");
		ret.path =  GwtSerDerUtils.STRING.deserialize(pathJSON);
		JSONValue emailJSON = json.get("email");
		ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		JSONValue hiddenJSON = json.get("hidden");
		ret.hidden =  GwtSerDerUtils.BOOLEAN.deserialize(hiddenJSON);
		JSONValue systemJSON = json.get("system");
		ret.system =  GwtSerDerUtils.BOOLEAN.deserialize(systemJSON);
		JSONValue archivedJSON = json.get("archived");
		ret.archived =  GwtSerDerUtils.BOOLEAN.deserialize(archivedJSON);
		JSONValue emailsJSON = json.get("emails");
		ret.emails =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).deserialize(emailsJSON);
		JSONValue orgUnitUidJSON = json.get("orgUnitUid");
		ret.orgUnitUid =  GwtSerDerUtils.STRING.deserialize(orgUnitUidJSON);
		JSONValue orgUnitPathJSON = json.get("orgUnitPath");
		ret.orgUnitPath =  new net.bluemind.directory.api.gwt.serder.OrgUnitPathGwtSerDer().deserialize(orgUnitPathJSON);
		JSONValue dataLocationJSON = json.get("dataLocation");
		ret.dataLocation =  GwtSerDerUtils.STRING.deserialize(dataLocationJSON);
		JSONValue minIdJSON = json.get("minId");
		ret.minId =  GwtSerDerUtils.INT.deserialize(minIdJSON);
	}

	public void deserializeTo(net.bluemind.directory.api.DirEntry ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("path")) {
			JSONValue pathJSON = json.get("path");
			ret.path =  GwtSerDerUtils.STRING.deserialize(pathJSON);
		}
		if (!childPropertiesToIgnore.contains("email")) {
			JSONValue emailJSON = json.get("email");
			ret.email =  GwtSerDerUtils.STRING.deserialize(emailJSON);
		}
		if (!childPropertiesToIgnore.contains("hidden")) {
			JSONValue hiddenJSON = json.get("hidden");
			ret.hidden =  GwtSerDerUtils.BOOLEAN.deserialize(hiddenJSON);
		}
		if (!childPropertiesToIgnore.contains("system")) {
			JSONValue systemJSON = json.get("system");
			ret.system =  GwtSerDerUtils.BOOLEAN.deserialize(systemJSON);
		}
		if (!childPropertiesToIgnore.contains("archived")) {
			JSONValue archivedJSON = json.get("archived");
			ret.archived =  GwtSerDerUtils.BOOLEAN.deserialize(archivedJSON);
		}
		if (!childPropertiesToIgnore.contains("emails")) {
			JSONValue emailsJSON = json.get("emails");
			ret.emails =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).deserialize(emailsJSON);
		}
		if (!childPropertiesToIgnore.contains("orgUnitUid")) {
			JSONValue orgUnitUidJSON = json.get("orgUnitUid");
			ret.orgUnitUid =  GwtSerDerUtils.STRING.deserialize(orgUnitUidJSON);
		}
		if (!childPropertiesToIgnore.contains("orgUnitPath")) {
			JSONValue orgUnitPathJSON = json.get("orgUnitPath");
			ret.orgUnitPath =  new net.bluemind.directory.api.gwt.serder.OrgUnitPathGwtSerDer().deserialize(orgUnitPathJSON);
		}
		if (!childPropertiesToIgnore.contains("dataLocation")) {
			JSONValue dataLocationJSON = json.get("dataLocation");
			ret.dataLocation =  GwtSerDerUtils.STRING.deserialize(dataLocationJSON);
		}
		if (!childPropertiesToIgnore.contains("minId")) {
			JSONValue minIdJSON = json.get("minId");
			ret.minId =  GwtSerDerUtils.INT.deserialize(minIdJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.directory.api.DirEntry o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.directory.api.DirEntry o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("path",  GwtSerDerUtils.STRING.serialize( o.path ));
		ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		ret.put("hidden",  GwtSerDerUtils.BOOLEAN.serialize( o.hidden ));
		ret.put("system",  GwtSerDerUtils.BOOLEAN.serialize( o.system ));
		ret.put("archived",  GwtSerDerUtils.BOOLEAN.serialize( o.archived ));
		ret.put("emails",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).serialize( o.emails ));
		ret.put("orgUnitUid",  GwtSerDerUtils.STRING.serialize( o.orgUnitUid ));
		ret.put("orgUnitPath",  new net.bluemind.directory.api.gwt.serder.OrgUnitPathGwtSerDer().serialize( o.orgUnitPath ));
		ret.put("dataLocation",  GwtSerDerUtils.STRING.serialize( o.dataLocation ));
		ret.put("minId",  GwtSerDerUtils.INT.serialize( o.minId ));
	}

	public void serializeTo(net.bluemind.directory.api.DirEntry o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("path")) {
			ret.put("path",  GwtSerDerUtils.STRING.serialize( o.path ));
		}
		if (!childPropertiesToIgnore.contains("email")) {
			ret.put("email",  GwtSerDerUtils.STRING.serialize( o.email ));
		}
		if (!childPropertiesToIgnore.contains("hidden")) {
			ret.put("hidden",  GwtSerDerUtils.BOOLEAN.serialize( o.hidden ));
		}
		if (!childPropertiesToIgnore.contains("system")) {
			ret.put("system",  GwtSerDerUtils.BOOLEAN.serialize( o.system ));
		}
		if (!childPropertiesToIgnore.contains("archived")) {
			ret.put("archived",  GwtSerDerUtils.BOOLEAN.serialize( o.archived ));
		}
		if (!childPropertiesToIgnore.contains("emails")) {
			ret.put("emails",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.api.gwt.serder.EmailGwtSerDer()).serialize( o.emails ));
		}
		if (!childPropertiesToIgnore.contains("orgUnitUid")) {
			ret.put("orgUnitUid",  GwtSerDerUtils.STRING.serialize( o.orgUnitUid ));
		}
		if (!childPropertiesToIgnore.contains("orgUnitPath")) {
			ret.put("orgUnitPath",  new net.bluemind.directory.api.gwt.serder.OrgUnitPathGwtSerDer().serialize( o.orgUnitPath ));
		}
		if (!childPropertiesToIgnore.contains("dataLocation")) {
			ret.put("dataLocation",  GwtSerDerUtils.STRING.serialize( o.dataLocation ));
		}
		if (!childPropertiesToIgnore.contains("minId")) {
			ret.put("minId",  GwtSerDerUtils.INT.serialize( o.minId ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}