/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2023
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.api.auth;

public enum AuthTypes {
	INTERNAL, KERBEROS, //
	CAS {
		@Override
		public boolean useBlueMindKeycloak() {
			return false;
		}
	},
	OPENID {
		@Override
		public boolean useBlueMindKeycloak() {
			return false;
		}
	};

	public boolean useBlueMindKeycloak() {
		return true;
	}

	public static AuthTypes get(String authTypeAsString) {
		AuthTypes authType = AuthTypes.INTERNAL;

		try {
			authType = AuthTypes.valueOf(authTypeAsString);
		} catch (NullPointerException | IllegalArgumentException iae) {
			// Consider INTERNAL authentication
		}

		return authType;
	}
}
