/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.task.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class TaskEndpointPromise implements net.bluemind.core.task.api.ITaskPromise {

	private net.bluemind.core.task.api.ITaskAsync impl;

	public TaskEndpointPromise(net.bluemind.core.task.api.ITaskAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<String>> getCurrentLogs(Integer offset  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getCurrentLogs(offset,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Stream> log() {
		
		CompletableFuture<Stream> ret = new CompletableFuture<Stream>();
		AsyncHandler<Stream> handler = new AsyncHandler<Stream>() {
			public void success(Stream value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.log( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskStatus> status() {
		
		CompletableFuture<net.bluemind.core.task.api.TaskStatus> ret = new CompletableFuture<net.bluemind.core.task.api.TaskStatus>();
		AsyncHandler<net.bluemind.core.task.api.TaskStatus> handler = new AsyncHandler<net.bluemind.core.task.api.TaskStatus>() {
			public void success(net.bluemind.core.task.api.TaskStatus value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.status( handler);
		return ret;
	}

}
