/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerSubscriptionGwtSerDer implements GwtSerDer<net.bluemind.core.container.api.ContainerSubscription> {

	public ContainerSubscriptionGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.api.ContainerSubscription deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.api.ContainerSubscription ret = new net.bluemind.core.container.api.ContainerSubscription();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerSubscription ret, JSONObject json) {
		JSONValue containerUidJSON = json.get("containerUid");
		ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		JSONValue offlineSyncJSON = json.get("offlineSync");
		ret.offlineSync =  GwtSerDerUtils.BOOLEAN.deserialize(offlineSyncJSON);
		JSONValue automountJSON = json.get("automount");
		ret.automount =  GwtSerDerUtils.BOOLEAN.deserialize(automountJSON);
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerSubscription ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("containerUid")) {
			JSONValue containerUidJSON = json.get("containerUid");
			ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		}
		if (!childPropertiesToIgnore.contains("offlineSync")) {
			JSONValue offlineSyncJSON = json.get("offlineSync");
			ret.offlineSync =  GwtSerDerUtils.BOOLEAN.deserialize(offlineSyncJSON);
		}
		if (!childPropertiesToIgnore.contains("automount")) {
			JSONValue automountJSON = json.get("automount");
			ret.automount =  GwtSerDerUtils.BOOLEAN.deserialize(automountJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.api.ContainerSubscription o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerSubscription o, JSONObject ret) {

		ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		ret.put("offlineSync",  GwtSerDerUtils.BOOLEAN.serialize( o.offlineSync ));
		ret.put("automount",  GwtSerDerUtils.BOOLEAN.serialize( o.automount ));
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerSubscription o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("containerUid")) {
			ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		}
		if (!childPropertiesToIgnore.contains("offlineSync")) {
			ret.put("offlineSync",  GwtSerDerUtils.BOOLEAN.serialize( o.offlineSync ));
		}
		if (!childPropertiesToIgnore.contains("automount")) {
			ret.put("automount",  GwtSerDerUtils.BOOLEAN.serialize( o.automount ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}