/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ContainerQueryGwtSerDer implements GwtSerDer<net.bluemind.core.container.api.ContainerQuery> {

	public ContainerQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.api.ContainerQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.api.ContainerQuery ret = new net.bluemind.core.container.api.ContainerQuery();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerQuery ret, JSONObject json) {
		JSONValue typeJSON = json.get("type");
		ret.type =  GwtSerDerUtils.STRING.deserialize(typeJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue verbJSON = json.get("verb");
		ret.verb =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).deserialize(verbJSON);
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		JSONValue readonlyJSON = json.get("readonly");
		ret.readonly =  GwtSerDerUtils.BOOLEAN.deserialize(readonlyJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
	}

	public void deserializeTo(net.bluemind.core.container.api.ContainerQuery ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  GwtSerDerUtils.STRING.deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("verb")) {
			JSONValue verbJSON = json.get("verb");
			ret.verb =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).deserialize(verbJSON);
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			JSONValue ownerJSON = json.get("owner");
			ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		}
		if (!childPropertiesToIgnore.contains("readonly")) {
			JSONValue readonlyJSON = json.get("readonly");
			ret.readonly =  GwtSerDerUtils.BOOLEAN.deserialize(readonlyJSON);
		}
		if (!childPropertiesToIgnore.contains("size")) {
			JSONValue sizeJSON = json.get("size");
			ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.core.container.api.ContainerQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerQuery o, JSONObject ret) {

		ret.put("type",  GwtSerDerUtils.STRING.serialize( o.type ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("verb",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).serialize( o.verb ));
		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		ret.put("readonly",  GwtSerDerUtils.BOOLEAN.serialize( o.readonly ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
	}

	public void serializeTo(net.bluemind.core.container.api.ContainerQuery o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  GwtSerDerUtils.STRING.serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("verb")) {
			ret.put("verb",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.acl.gwt.serder.VerbGwtSerDer()).serialize( o.verb ));
		}
		if (!childPropertiesToIgnore.contains("owner")) {
			ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		}
		if (!childPropertiesToIgnore.contains("readonly")) {
			ret.put("readonly",  GwtSerDerUtils.BOOLEAN.serialize( o.readonly ));
		}
		if (!childPropertiesToIgnore.contains("size")) {
			ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}