/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.core.container.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsAck extends JavaScriptObject {

	protected JsAck() {}

	public final native java.lang.Long getVersion()
	/*-{
	return this["version"];
	}-*/;

	public final native void setVersion(java.lang.Long version)
	/*-{
       this["version"] = version;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getTimestamp()
	/*-{
       if(this["timestamp"]) {
          return new Date(this["timestamp"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setTimestamp(com.google.gwt.core.client.JsDate timestamp)
	/*-{
       this["timestamp"] =  ( timestamp != null) ? timestamp.getTime() : null;
	}-*/;

	public static native  JsAck create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}