/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class OwnerSubscriptionsGwtEndpoint implements net.bluemind.core.container.api.IOwnerSubscriptionsAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public OwnerSubscriptionsGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/containers/_subscriptions/{domainUid}/{ownerUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{domainUid}", URL.encodePathSegment(pathVars[0]));
				uri_ = uri_.replace("{ownerUid}", URL.encodePathSegment(pathVars[1]));
		
		baseUri = uri_;
	}

	public OwnerSubscriptionsGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void changeset(Long since, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler) {
		String postUri = "/_changeset";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<String>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<String> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void changesetById(Long since, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler) {
		String postUri = "/_changesetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<Long>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<Long> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(GwtSerDerUtils.LONG).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void filteredChangesetById(Long since, net.bluemind.core.container.model.ItemFlagFilter filter, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler) {
		String postUri = "/_filteredChangesetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( filter);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemVersionGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void fullChangesetById(Long since, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/_fullChangesetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> handler) {
		String postUri = "/{uid}/complete";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.core.container.api.gwt.serder.ContainerSubscriptionModelGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getCompleteById(long id, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> handler) {
		String postUri = "/{id}/completeById";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.core.container.api.gwt.serder.ContainerSubscriptionModelGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getMultiple(List<String> uids, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> handler) {
		String postUri = "/_mget";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( uids);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.core.container.api.gwt.serder.ContainerSubscriptionModelGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getVersion(final AsyncHandler<Long> handler) {
		String postUri = "/_version";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Long>(handler) {
			@Override
			protected Long handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.LONG.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void list(final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> handler) {
		String postUri = "/_list";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.core.container.api.gwt.serder.ContainerSubscriptionModelGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void multipleGetById(List<Long> ids, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>> handler) {
		String postUri = "/_mgetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( ids);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.core.container.api.gwt.serder.ContainerSubscriptionModelGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.core.container.api.IOwnerSubscriptionsPromise promiseApi() {
		return new OwnerSubscriptionsEndpointPromise(this);
	}
}
