/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardChangesItemAddGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCardChanges.ItemAdd> {

	public VCardChangesItemAddGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCardChanges.ItemAdd deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCardChanges.ItemAdd ret = new net.bluemind.addressbook.api.VCardChanges.ItemAdd();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCardChanges.ItemAdd ret, JSONObject json) {
		JSONValue uidJSON = json.get("uid");
		ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().deserialize(valueJSON);
		JSONValue photoJSON = json.get("photo");
		ret.photo =  new GwtSerDerUtils.ByteArraySerDer().deserialize(photoJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCardChanges.ItemAdd ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("uid")) {
			JSONValue uidJSON = json.get("uid");
			ret.uid =  GwtSerDerUtils.STRING.deserialize(uidJSON);
		}
		if (!childPropertiesToIgnore.contains("value")) {
			JSONValue valueJSON = json.get("value");
			ret.value =  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().deserialize(valueJSON);
		}
		if (!childPropertiesToIgnore.contains("photo")) {
			JSONValue photoJSON = json.get("photo");
			ret.photo =  new GwtSerDerUtils.ByteArraySerDer().deserialize(photoJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCardChanges.ItemAdd o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCardChanges.ItemAdd o, JSONObject ret) {

		ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		ret.put("value",  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().serialize( o.value ));
		ret.put("photo",  new GwtSerDerUtils.ByteArraySerDer().serialize( o.photo ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCardChanges.ItemAdd o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("uid")) {
			ret.put("uid",  GwtSerDerUtils.STRING.serialize( o.uid ));
		}
		if (!childPropertiesToIgnore.contains("value")) {
			ret.put("value",  new net.bluemind.addressbook.api.gwt.serder.VCardGwtSerDer().serialize( o.value ));
		}
		if (!childPropertiesToIgnore.contains("photo")) {
			ret.put("photo",  new GwtSerDerUtils.ByteArraySerDer().serialize( o.photo ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}