/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.MailFilterRule> {

	public MailFilterRuleGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.MailFilterRule deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.rules.MailFilterRule ret = new net.bluemind.mailbox.api.rules.MailFilterRule();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.MailFilterRule ret, JSONObject json) {
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.LONG.deserialize(idJSON);
		JSONValue clientJSON = json.get("client");
		ret.client =  GwtSerDerUtils.STRING.deserialize(clientJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleTypeGwtSerDer().deserialize(typeJSON);
		JSONValue triggerJSON = json.get("trigger");
		ret.trigger =  new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleTriggerGwtSerDer().deserialize(triggerJSON);
		JSONValue deferredJSON = json.get("deferred");
		ret.deferred =  GwtSerDerUtils.BOOLEAN.deserialize(deferredJSON);
		JSONValue activeJSON = json.get("active");
		ret.active =  GwtSerDerUtils.BOOLEAN.deserialize(activeJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue clientPropertiesJSON = json.get("clientProperties");
		ret.clientProperties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(clientPropertiesJSON);
		JSONValue conditionsJSON = json.get("conditions");
		ret.conditions =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionGwtSerDer()).deserialize(conditionsJSON);
		JSONValue actionsJSON = json.get("actions");
		ret.actions =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionGwtSerDer()).deserialize(actionsJSON);
		JSONValue stopJSON = json.get("stop");
		ret.stop =  GwtSerDerUtils.BOOLEAN.deserialize(stopJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.MailFilterRule ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("id")) {
			JSONValue idJSON = json.get("id");
			ret.id =  GwtSerDerUtils.LONG.deserialize(idJSON);
		}
		if (!childPropertiesToIgnore.contains("client")) {
			JSONValue clientJSON = json.get("client");
			ret.client =  GwtSerDerUtils.STRING.deserialize(clientJSON);
		}
		if (!childPropertiesToIgnore.contains("type")) {
			JSONValue typeJSON = json.get("type");
			ret.type =  new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleTypeGwtSerDer().deserialize(typeJSON);
		}
		if (!childPropertiesToIgnore.contains("trigger")) {
			JSONValue triggerJSON = json.get("trigger");
			ret.trigger =  new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleTriggerGwtSerDer().deserialize(triggerJSON);
		}
		if (!childPropertiesToIgnore.contains("deferred")) {
			JSONValue deferredJSON = json.get("deferred");
			ret.deferred =  GwtSerDerUtils.BOOLEAN.deserialize(deferredJSON);
		}
		if (!childPropertiesToIgnore.contains("active")) {
			JSONValue activeJSON = json.get("active");
			ret.active =  GwtSerDerUtils.BOOLEAN.deserialize(activeJSON);
		}
		if (!childPropertiesToIgnore.contains("name")) {
			JSONValue nameJSON = json.get("name");
			ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		}
		if (!childPropertiesToIgnore.contains("clientProperties")) {
			JSONValue clientPropertiesJSON = json.get("clientProperties");
			ret.clientProperties =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(clientPropertiesJSON);
		}
		if (!childPropertiesToIgnore.contains("conditions")) {
			JSONValue conditionsJSON = json.get("conditions");
			ret.conditions =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionGwtSerDer()).deserialize(conditionsJSON);
		}
		if (!childPropertiesToIgnore.contains("actions")) {
			JSONValue actionsJSON = json.get("actions");
			ret.actions =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionGwtSerDer()).deserialize(actionsJSON);
		}
		if (!childPropertiesToIgnore.contains("stop")) {
			JSONValue stopJSON = json.get("stop");
			ret.stop =  GwtSerDerUtils.BOOLEAN.deserialize(stopJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.MailFilterRule o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.MailFilterRule o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.LONG.serialize( o.id ));
		ret.put("client",  GwtSerDerUtils.STRING.serialize( o.client ));
		ret.put("type",  new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleTypeGwtSerDer().serialize( o.type ));
		ret.put("trigger",  new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleTriggerGwtSerDer().serialize( o.trigger ));
		ret.put("deferred",  GwtSerDerUtils.BOOLEAN.serialize( o.deferred ));
		ret.put("active",  GwtSerDerUtils.BOOLEAN.serialize( o.active ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("clientProperties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.clientProperties ));
		ret.put("conditions",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionGwtSerDer()).serialize( o.conditions ));
		ret.put("actions",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionGwtSerDer()).serialize( o.actions ));
		ret.put("stop",  GwtSerDerUtils.BOOLEAN.serialize( o.stop ));
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.MailFilterRule o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("id")) {
			ret.put("id",  GwtSerDerUtils.LONG.serialize( o.id ));
		}
		if (!childPropertiesToIgnore.contains("client")) {
			ret.put("client",  GwtSerDerUtils.STRING.serialize( o.client ));
		}
		if (!childPropertiesToIgnore.contains("type")) {
			ret.put("type",  new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleTypeGwtSerDer().serialize( o.type ));
		}
		if (!childPropertiesToIgnore.contains("trigger")) {
			ret.put("trigger",  new net.bluemind.mailbox.api.rules.gwt.serder.MailFilterRuleTriggerGwtSerDer().serialize( o.trigger ));
		}
		if (!childPropertiesToIgnore.contains("deferred")) {
			ret.put("deferred",  GwtSerDerUtils.BOOLEAN.serialize( o.deferred ));
		}
		if (!childPropertiesToIgnore.contains("active")) {
			ret.put("active",  GwtSerDerUtils.BOOLEAN.serialize( o.active ));
		}
		if (!childPropertiesToIgnore.contains("name")) {
			ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		}
		if (!childPropertiesToIgnore.contains("clientProperties")) {
			ret.put("clientProperties",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.clientProperties ));
		}
		if (!childPropertiesToIgnore.contains("conditions")) {
			ret.put("conditions",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.conditions.gwt.serder.MailFilterRuleConditionGwtSerDer()).serialize( o.conditions ));
		}
		if (!childPropertiesToIgnore.contains("actions")) {
			ret.put("actions",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionGwtSerDer()).serialize( o.actions ));
		}
		if (!childPropertiesToIgnore.contains("stop")) {
			ret.put("stop",  GwtSerDerUtils.BOOLEAN.serialize( o.stop ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}