/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.rules.conditions.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailFilterRuleFilterContainsComparator extends JavaScriptObject {

	protected JsMailFilterRuleFilterContainsComparator() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsMailFilterRuleFilterContainsComparator FULLSTRING()
	/*-{
		return "FULLSTRING";
	}-*/;

	public static final native JsMailFilterRuleFilterContainsComparator SUBSTRING()
	/*-{
		return "SUBSTRING";
	}-*/;

	public static final native JsMailFilterRuleFilterContainsComparator PREFIX()
	/*-{
		return "PREFIX";
	}-*/;

	public static final JsMailFilterRuleFilterContainsComparator create(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterContains.Comparator value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case FULLSTRING:
				return FULLSTRING();
			case SUBSTRING:
				return SUBSTRING();
			case PREFIX:
				return PREFIX();
			default:
				return null;
			}
		}
	}
}