/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.rules.conditions.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailFilterRuleConditionOperator extends JavaScriptObject {

	protected JsMailFilterRuleConditionOperator() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsMailFilterRuleConditionOperator OR()
	/*-{
		return "OR";
	}-*/;

	public static final native JsMailFilterRuleConditionOperator AND()
	/*-{
		return "AND";
	}-*/;

	public static final JsMailFilterRuleConditionOperator create(net.bluemind.mailbox.api.rules.conditions.MailFilterRuleCondition.Operator value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case OR:
				return OR();
			case AND:
				return AND();
			default:
				return null;
			}
		}
	}
}