/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.actions.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleActionCategorizeGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize> {

	private net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionAddHeadersGwtSerDer parent = new  net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionAddHeadersGwtSerDer();
	public MailFilterRuleActionCategorizeGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize ret = new net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

	}

	public void serializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCategorize o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}