/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.mailbox.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsMailFilterVacation extends JavaScriptObject {

	protected JsMailFilterVacation() {}

	public final native boolean getEnabled()
	/*-{
	return this["enabled"];
	}-*/;

	public final native void setEnabled(boolean enabled)
	/*-{
       this["enabled"] = enabled;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getStart()
	/*-{
       if(this["start"]) {
          return new Date(this["start"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setStart(com.google.gwt.core.client.JsDate start)
	/*-{
       this["start"] =  ( start != null) ? start.getTime() : null;
	}-*/;

	public final native com.google.gwt.core.client.JsDate getEnd()
	/*-{
       if(this["end"]) {
          return new Date(this["end"]);
       } else {
          return null;
       }
	}-*/;

	public final native void setEnd(com.google.gwt.core.client.JsDate end)
	/*-{
       this["end"] =  ( end != null) ? end.getTime() : null;
	}-*/;

	public final native String getText()
	/*-{
	return this["text"];
	}-*/;

	public final native void setText(String text)
	/*-{
       this["text"] = text;
	}-*/;

	public final native String getTextHtml()
	/*-{
	return this["textHtml"];
	}-*/;

	public final native void setTextHtml(String textHtml)
	/*-{
       this["textHtml"] = textHtml;
	}-*/;

	public final native String getSubject()
	/*-{
	return this["subject"];
	}-*/;

	public final native void setSubject(String subject)
	/*-{
       this["subject"] = subject;
	}-*/;

	public static native  JsMailFilterVacation create()
	/*-{
       var ret = {};
       return ret;
	}-*/;

}