package net.bluemind.backend.mail.api;
import net.bluemind.core.api.BMPromiseApi;
import java.util.concurrent.CompletableFuture;

@BMPromiseApi(net.bluemind.backend.mail.api.IMailboxItemsAsync.class)
public interface IMailboxItemsPromise  {

	CompletableFuture<net.bluemind.core.container.api.Ack> addFlag(net.bluemind.backend.mail.api.flags.FlagUpdate flagUpdate);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.String>> changeset(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<java.lang.Long>> changesetById(java.lang.Long since);

	CompletableFuture<net.bluemind.core.container.api.Count> count(net.bluemind.core.container.model.ItemFlagFilter arg0);

	CompletableFuture<net.bluemind.backend.mail.api.ImapItemIdentifier> create(net.bluemind.backend.mail.api.MailboxItem value);

	CompletableFuture<net.bluemind.core.container.api.Ack> createById(long id, net.bluemind.backend.mail.api.MailboxItem arg1);

	CompletableFuture<Void> deleteById(long id);

	CompletableFuture<net.bluemind.core.container.api.Ack> deleteFlag(net.bluemind.backend.mail.api.flags.FlagUpdate flagUpdate);

	CompletableFuture<Void> expunge();

	CompletableFuture<net.bluemind.core.api.Stream> fetch(long imapUid, java.lang.String address, java.lang.String encoding, java.lang.String mime, java.lang.String charset, java.lang.String filename);

	CompletableFuture<net.bluemind.core.api.Stream> fetchComplete(long imapUid);

	CompletableFuture<net.bluemind.core.api.Stream> fetchCompleteByGuid(java.lang.String guid);

	CompletableFuture<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> filteredChangesetById(java.lang.Long since, net.bluemind.core.container.model.ItemFlagFilter arg1);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> getCompleteById(long id);

	CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>> getForUpdate(long id);

	CompletableFuture<Long> getVersion();

	CompletableFuture<net.bluemind.core.container.model.ItemChangelog> itemChangelog(java.lang.String uid, java.lang.Long arg1);

	CompletableFuture<java.util.List<java.lang.Long>> listItemIdsAfter(net.bluemind.core.api.date.BmDateTime before);

	CompletableFuture<Void> multipleDeleteById(java.util.List<java.lang.Long> arg0, java.lang.Boolean bypassDeletedItems);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemValue<net.bluemind.backend.mail.api.MailboxItem>>> multipleGetById(java.util.List<java.lang.Long> arg0);

	CompletableFuture<java.util.List<net.bluemind.core.container.model.ItemIdentifier>> multipleUnexpungeById(java.util.List<java.lang.Long> itemIds);

	CompletableFuture<java.util.List<java.lang.Long>> recentItems(java.util.Date deliveredOrUpdatedAfter);

	CompletableFuture<Void> removePart(java.lang.String partId);

	CompletableFuture<java.util.List<java.lang.Long>> sortedIds(net.bluemind.core.container.model.SortDescriptor arg0);

	CompletableFuture<java.util.List<java.lang.String>> sortedUids(net.bluemind.core.container.model.SortDescriptor arg0);

	CompletableFuture<net.bluemind.core.container.model.ItemIdentifier> unexpunge(long itemId);

	CompletableFuture<java.util.List<java.lang.Long>> unreadItems();

	CompletableFuture<net.bluemind.core.container.api.Ack> updateById(long id, net.bluemind.backend.mail.api.MailboxItem arg1);

	CompletableFuture<java.lang.String> uploadPart(net.bluemind.core.api.Stream part);

}