/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.parameter;

import java.util.Locale;
import net.fortuna.ical4j.vcard.AbstractFactory;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.ParameterFactory;
import org.apache.commons.lang3.StringUtils;

public final class Language
extends Parameter {
    private static final long serialVersionUID = 8762124184853766503L;
    private final Locale locale;

    public Language(String value) {
        this(new Locale(value));
    }

    public Language(Locale locale) {
        super(Parameter.Id.LANGUAGE);
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public String getValue() {
        StringBuilder b = new StringBuilder();
        b.append(this.locale.getLanguage());
        if (!StringUtils.isEmpty((CharSequence)this.locale.getCountry())) {
            b.append('-');
            b.append(this.locale.getCountry());
        }
        if (!StringUtils.isEmpty((CharSequence)this.locale.getVariant())) {
            b.append('-');
            b.append(this.locale.getVariant());
        }
        return b.toString();
    }

    public static class Factory
    extends AbstractFactory
    implements ParameterFactory<Language> {
        public Factory() {
            super(Parameter.Id.LANGUAGE.toString());
        }

        @Override
        public Language createParameter(String name, String value) {
            return new Language(new Locale(value));
        }
    }
}

