/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2022
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.service.internal;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import net.bluemind.calendar.api.ICalendarUids;
import net.bluemind.calendar.persistence.VEventIndexStore;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.persistence.DataSourceRouter;
import net.bluemind.core.rest.BmContext;
import net.bluemind.indexing.incremental.hooks.IIncrementalIndexingContainersHook;
import net.bluemind.lib.elasticsearch.ESearchActivator;

public class CalendarContainerHook implements IIncrementalIndexingContainersHook {
	private static final Logger logger = LoggerFactory.getLogger(CalendarContainerHook.class);

	@Override
	public void onContainerDeleted(BmContext ctx, String uid, String type) throws ServerFault {
		if (type.equals(ICalendarUids.TYPE)) {
			logger.info("delete all calendar elements for container uid: {}", uid);
			ElasticsearchClient esClient = ESearchActivator.getClient();
			Container cont = new Container();
			cont.uid = uid;
			VEventIndexStore indexStore = new VEventIndexStore(esClient, cont, DataSourceRouter.location(ctx, uid));
			indexStore.deleteAll();

		}
	}

}
