<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ExternalSystem.
 */
class ExternalSystem  {

  /*
   * @type String
   */
  public $identifier;

  /*
   * @type String
   */
  public $description;

  /*
   * @type ExternalSystemAuthKind
   */
  public $authKind;

  /*
   * @type Map
   */
  public $properties;

  /*
   * Constructor
   */
  public function __construct() {
    $this->identifier = "";
    $this->description = "";
    $this->properties = array();
  }

  public function toMap() {
    $data = array(    
        "identifier" => empty($this->identifier) ? null : $this->identifier,    
        "description" => empty($this->description) ? null : $this->description,    
        "authKind" => empty($this->authKind) ? null : $this->authKind,    
        "properties" => empty($this->properties) ? null : $this->properties);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
