/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailboxItemGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MailboxItem> {

	public MailboxItemGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MailboxItem deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MailboxItem ret = new net.bluemind.backend.mail.api.MailboxItem();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MailboxItem ret, JSONObject json) {
		JSONValue bodyJSON = json.get("body");
		ret.body =  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyGwtSerDer().deserialize(bodyJSON);
		JSONValue imapUidJSON = json.get("imapUid");
		ret.imapUid =  GwtSerDerUtils.LONG.deserialize(imapUidJSON);
		JSONValue flagsJSON = json.get("flags");
		ret.flags =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.flags.gwt.serder.MailboxItemFlagGwtSerDer()).deserialize(flagsJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MailboxItem ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("body")) {
			JSONValue bodyJSON = json.get("body");
			ret.body =  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyGwtSerDer().deserialize(bodyJSON);
		}
		if (!childPropertiesToIgnore.contains("imapUid")) {
			JSONValue imapUidJSON = json.get("imapUid");
			ret.imapUid =  GwtSerDerUtils.LONG.deserialize(imapUidJSON);
		}
		if (!childPropertiesToIgnore.contains("flags")) {
			JSONValue flagsJSON = json.get("flags");
			ret.flags =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.flags.gwt.serder.MailboxItemFlagGwtSerDer()).deserialize(flagsJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MailboxItem o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MailboxItem o, JSONObject ret) {

		ret.put("body",  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyGwtSerDer().serialize( o.body ));
		ret.put("imapUid",  GwtSerDerUtils.LONG.serialize( o.imapUid ));
		ret.put("flags",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.flags.gwt.serder.MailboxItemFlagGwtSerDer()).serialize( o.flags ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.MailboxItem o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("body")) {
			ret.put("body",  new net.bluemind.backend.mail.api.gwt.serder.MessageBodyGwtSerDer().serialize( o.body ));
		}
		if (!childPropertiesToIgnore.contains("imapUid")) {
			ret.put("imapUid",  GwtSerDerUtils.LONG.serialize( o.imapUid ));
		}
		if (!childPropertiesToIgnore.contains("flags")) {
			ret.put("flags",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.flags.gwt.serder.MailboxItemFlagGwtSerDer()).serialize( o.flags ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}