/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.flags.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ImportMailboxConversationSetGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet> {

	public ImportMailboxConversationSetGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet ret = new net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet ret, JSONObject json) {
		JSONValue mailboxFolderIdJSON = json.get("mailboxFolderId");
		ret.mailboxFolderId =  GwtSerDerUtils.LONG.deserialize(mailboxFolderIdJSON);
		JSONValue conversationUidsJSON = json.get("conversationUids");
		ret.conversationUids =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(conversationUidsJSON);
		JSONValue deleteFromSourceJSON = json.get("deleteFromSource");
		ret.deleteFromSource =  GwtSerDerUtils.BOOLEAN.deserialize(deleteFromSourceJSON);
	}

	public void deserializeTo(net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("mailboxFolderId")) {
			JSONValue mailboxFolderIdJSON = json.get("mailboxFolderId");
			ret.mailboxFolderId =  GwtSerDerUtils.LONG.deserialize(mailboxFolderIdJSON);
		}
		if (!childPropertiesToIgnore.contains("conversationUids")) {
			JSONValue conversationUidsJSON = json.get("conversationUids");
			ret.conversationUids =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(conversationUidsJSON);
		}
		if (!childPropertiesToIgnore.contains("deleteFromSource")) {
			JSONValue deleteFromSourceJSON = json.get("deleteFromSource");
			ret.deleteFromSource =  GwtSerDerUtils.BOOLEAN.deserialize(deleteFromSourceJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet o, JSONObject ret) {

		ret.put("mailboxFolderId",  GwtSerDerUtils.LONG.serialize( o.mailboxFolderId ));
		ret.put("conversationUids",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.conversationUids ));
		ret.put("deleteFromSource",  GwtSerDerUtils.BOOLEAN.serialize( o.deleteFromSource ));
	}

	public void serializeTo(net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("mailboxFolderId")) {
			ret.put("mailboxFolderId",  GwtSerDerUtils.LONG.serialize( o.mailboxFolderId ));
		}
		if (!childPropertiesToIgnore.contains("conversationUids")) {
			ret.put("conversationUids",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.conversationUids ));
		}
		if (!childPropertiesToIgnore.contains("deleteFromSource")) {
			ret.put("deleteFromSource",  GwtSerDerUtils.BOOLEAN.serialize( o.deleteFromSource ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}