/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.user.service.internal.cql;

import java.util.List;
import java.util.function.Supplier;

import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.container.api.ItemValueExists;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.rest.BmContext;
import net.bluemind.directory.api.DirEntry;
import net.bluemind.directory.cql.common.CqlContStoreService;
import net.bluemind.directory.repository.DirEntryNG;
import net.bluemind.domain.api.Domain;
import net.bluemind.mailbox.api.Mailbox;
import net.bluemind.mailbox.identity.api.IdentityDescription;
import net.bluemind.mailbox.identity.api.SignatureFormat;
import net.bluemind.user.api.IInternalUserMailIdentities;
import net.bluemind.user.api.IUserMailIdentities;
import net.bluemind.user.api.UserMailIdentity;

public class CqlUserIdentities implements IUserMailIdentities, IInternalUserMailIdentities {

	private final CqlContStoreService store;
	private final Supplier<ItemValue<DirEntryNG>> current;

	public CqlUserIdentities(BmContext context, ItemValue<Domain> domain, Container usersContainer, String userUid) {
		this.store = new CqlContStoreService(context, usersContainer, domain);
		this.current = () -> store.get(userUid, null);
	}

	@Override
	public void restore(ItemValue<UserMailIdentity> item, boolean isCreate) {
		// TODO Auto-generated method stub

	}

	@Override
	public ItemValueExists itemValueExists(String uid) {
		ItemValue<DirEntryNG> cur = current.get();
		if (cur == null) {
			return ItemValueExists.DOESNOTEXISTS;
		}
		if (cur.value == null) {
			return new ItemValueExists(true, false);
		}
		return new ItemValueExists(true, cur.value.signatures.stream().anyMatch(s -> s.name.equals(uid)));
	}

	@Override
	public void createDefaultIdentity(ItemValue<Mailbox> mailboxItem, DirEntry dirEntry) throws ServerFault {
		// TODO Auto-generated method stub

	}

	@Override
	public void create(String id, UserMailIdentity identity) throws ServerFault {
		// TODO Auto-generated method stub

	}

	@Override
	public void update(String id, UserMailIdentity identity) throws ServerFault {
		// TODO Auto-generated method stub

	}

	@Override
	public void delete(String id) throws ServerFault {
		// TODO Auto-generated method stub

	}

	@Override
	public UserMailIdentity get(String id) throws ServerFault {
		if (!id.equals("default")) {
			throw ServerFault.notFound("ident " + id + " not found");
		}
		var desc = defaultIdent();
		UserMailIdentity mi = new UserMailIdentity();
		mi.displayname = desc.displayname;
		mi.email = desc.email;
		mi.isDefault = desc.isDefault;
		mi.sentFolder = "Sent";
		mi.signature = desc.signature;
		mi.mailboxUid = desc.mbox;
		mi.format = SignatureFormat.PLAIN;
		return mi;
	}

	@Override
	public void setDefault(String id) throws ServerFault {
		// TODO Auto-generated method stub

	}

	@Override
	public List<IdentityDescription> getIdentities() throws ServerFault {
		return List.of(defaultIdent());
	}

	private IdentityDescription defaultIdent() {
		IdentityDescription id = new IdentityDescription();
		ItemValue<DirEntryNG> de = current.get();
		id.email = de.value.email;
		id.emailIsDefault = true;
		id.displayname = de.displayName;
		id.mbox = de.uid;
		id.mboxName = de.value.mailboxName;
		id.name = id.displayname;
		id.signature = "";
		id.id = "default";
		id.isDefault = true;
		return id;
	}

	@Override
	public List<IdentityDescription> getAvailableIdentities() throws ServerFault {
		// TODO Auto-generated method stub
		return getIdentities();
	}

}
