/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2017
 *
 * This file is part of Blue Mind. Blue Mind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License)
 * or the CeCILL as published by CeCILL.info (version 2 of the License).
 *
 * There are special exceptions to the terms and conditions of the
 * licenses as they are applied to this program. See LICENSE.txt in
 * the directory of this program distribution.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.replica.service;

import java.util.Set;

import net.bluemind.backend.mail.api.IMailboxFolders;
import net.bluemind.backend.mail.replica.api.MailboxReplica;
import net.bluemind.backend.mail.replica.api.MailboxReplicaRootDescriptor;
import net.bluemind.backend.mail.replica.service.internal.ImapReplicatedMailboxesService;
import net.bluemind.backend.mail.replica.service.internal.VisibilityLimitedImapReplicatedMailboxesService;
import net.bluemind.backend.mail.repository.IMailboxReplicaStore;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.ContainerUid;
import net.bluemind.core.container.model.DataLocation;
import net.bluemind.core.container.model.acl.Verb;
import net.bluemind.core.container.repository.IAclStore;
import net.bluemind.core.container.repository.IContainerRouteStore;
import net.bluemind.core.container.repository.IContainerStore;
import net.bluemind.core.container.service.internal.ContainerStoreService;
import net.bluemind.core.container.service.internal.RBACManager;
import net.bluemind.core.rest.BmContext;
import net.bluemind.mailbox.api.IMailboxAclUids;
import net.bluemind.repository.provider.RepositoryProvider;

public class ImapReplicatedMailboxesServiceFactory extends AbstractReplicatedMailboxesServiceFactory<IMailboxFolders> {

	@Override
	public Class<IMailboxFolders> factoryClass() {
		return IMailboxFolders.class;
	}

	@Override
	protected IMailboxFolders create(MailboxReplicaRootDescriptor root, Container cont, BmContext context,
			IMailboxReplicaStore mboxReplicaStore, ContainerStoreService<MailboxReplica> storeService,
			IContainerStore containerStore, IAclStore aclStore) {
		IContainerRouteStore router = RepositoryProvider.instance(IContainerRouteStore.class, context);
		DataLocation dataLocation = router.routeOf(ContainerUid.of(cont.uid));

		RBACManager rbac = RBACManager.forContext(context).forContainer(IMailboxAclUids.uidForMailbox(cont.owner));

		ImapReplicatedMailboxesService parent = new ImapReplicatedMailboxesService(root, cont, context,
				mboxReplicaStore, storeService, containerStore, aclStore);

		if (!rbac.can(Set.of(Verb.Read.name())) && rbac.can(Set.of(Verb.Visible.name()))) {
			return new VisibilityLimitedImapReplicatedMailboxesService(context, cont, dataLocation, parent,
					storeService, rbac);
		} else {
			return parent;
		}
	}

}
