/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.domain.cql.store.factories;

import net.bluemind.core.api.DataSourceType;
import net.bluemind.core.api.fault.ServerFault;
import net.bluemind.core.rest.BmContext;
import net.bluemind.cql.CqlSessions;
import net.bluemind.domain.cql.store.CqlDomainStore;
import net.bluemind.domain.repository.IDomainStore;
import net.bluemind.repository.provider.IStandaloneFactory;

public class DomainStoreFactory implements IStandaloneFactory<IDomainStore> {

	@Override
	public Class<IDomainStore> factoryClass() {
		return IDomainStore.class;
	}

	@Override
	public DataSourceType targetRepositoryType() {
		return DataSourceType.CQL;
	}

	@Override
	public IDomainStore instance(BmContext context) throws ServerFault {
		return new CqlDomainStore(CqlSessions.forKeyspace("core"));
	}

}
