/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.domain.cql.store;

import java.sql.SQLException;
import java.util.List;

import com.datastax.oss.driver.api.core.CqlSession;

import net.bluemind.core.container.model.Item;
import net.bluemind.cql.persistence.CqlAbstractStore;
import net.bluemind.domain.api.DomainSettings;
import net.bluemind.domain.repository.IDomainSettingsStore;

public class CqlDomainSettingsStore extends CqlAbstractStore implements IDomainSettingsStore {

	public CqlDomainSettingsStore(CqlSession s) {
		super(s);
	}

	@Override
	public void create(Item item, DomainSettings value) throws SQLException {
		update(item, value);
	}

	@Override
	public void update(Item item, DomainSettings value) throws SQLException {
		voidCql("UPDATE t_domain SET settings=? WHERE item_id=? AND name=?", value.settings, item.id, item.uid);
	}

	@Override
	public void delete(Item item) throws SQLException {
		// NOOP
	}

	@Override
	public DomainSettings get(Item item) throws SQLException {
		return unique("SELECT settings FROM t_domain WHERE item_id=?", r -> new DomainSettings(item.uid, null),
				(r, i, v) -> {
					v.settings = r.getMap(0, String.class, String.class);
					return i;
				}, item.id);
	}

	@Override
	public void deleteAll() throws SQLException {
		throw new UnsupportedOperationException();
	}

	@Override
	public List<DomainSettings> getMultiple(List<Item> items) throws SQLException {
		throw new UnsupportedOperationException();
	}

	@Override
	public boolean exists(Item item) throws SQLException {
		throw new UnsupportedOperationException();
	}

}
