/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.webappdata.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONValue;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class WebAppDataGwtEndpoint implements net.bluemind.webappdata.api.IWebAppDataAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public WebAppDataGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/webappdata/{containerUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{containerUid}", URL.encodePathSegment(pathVars[0]));
		
		baseUri = uri_;
	}

	public WebAppDataGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void allUids(final AsyncHandler<List<String>> handler) {
		String postUri = "/_alluids";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<String>>(handler) {
			@Override
			protected List<String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void changeset(Long since, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<String>> handler) {
		String postUri = "/_changeset";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<String>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<String> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(GwtSerDerUtils.STRING).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void changesetById(Long since, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<Long>> handler) {
		String postUri = "/_changesetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<Long>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<Long> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(GwtSerDerUtils.LONG).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void create(String uid, net.bluemind.webappdata.api.WebAppData arg1, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/uid/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.PUT, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.webappdata.api.gwt.serder.WebAppDataGwtSerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.api.Ack>(handler) {
			@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void delete(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/uid/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void deleteAll(final AsyncHandler<Void> handler) {
		String postUri = "/_deleteAll";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void filteredChangesetById(Long since, net.bluemind.core.container.model.ItemFlagFilter arg1, final AsyncHandler<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>> handler) {
		String postUri = "/_filteredChangesetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&since=" + URL.encodeQueryString(""+since);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.core.container.model.gwt.serder.ItemFlagFilterGwtSerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ContainerChangesetGwtSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemVersionGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getByKey(String key, final AsyncHandler<net.bluemind.webappdata.api.WebAppData> handler) {
		String postUri = "/key/{key}";

		postUri = postUri.replace("{key}", URL.encodePathSegment(""+key));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.webappdata.api.WebAppData>(handler) {
			@Override
			protected net.bluemind.webappdata.api.WebAppData handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.webappdata.api.gwt.serder.WebAppDataGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getComplete(String uid, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> handler) {
		String postUri = "/uid/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.webappdata.api.gwt.serder.WebAppDataGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getCompleteById(long id, final AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> handler) {
		String postUri = "/{id}/completeById";

		postUri = postUri.replace("{id}", URL.encodePathSegment(""+id));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.webappdata.api.gwt.serder.WebAppDataGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getVersion(final AsyncHandler<Long> handler) {
		String postUri = "/_version";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Long>(handler) {
			@Override
			protected Long handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.LONG.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void itemChangelog(String uid, Long arg1, final AsyncHandler<net.bluemind.core.container.model.ItemChangelog> handler) {
		String postUri = "/{uid}/_itemchangelog";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = GwtSerDerUtils.LONG.serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.model.ItemChangelog>(handler) {
			@Override
			protected net.bluemind.core.container.model.ItemChangelog handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.model.gwt.serder.ItemChangelogGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void multipleGet(List<String> arg0, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>> handler) {
		String postUri = "/uid/_mget";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.webappdata.api.gwt.serder.WebAppDataGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void multipleGetById(List<Long> arg0, final AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>> handler) {
		String postUri = "/_mgetById";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( arg0);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemValue<net.bluemind.webappdata.api.WebAppData>> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.webappdata.api.gwt.serder.WebAppDataGwtSerDer())).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void update(String uid, net.bluemind.webappdata.api.WebAppData arg1, final AsyncHandler<net.bluemind.core.container.api.Ack> handler) {
		String postUri = "/uid/{uid}";

		postUri = postUri.replace("{uid}", URL.encodePathSegment(""+uid));
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.webappdata.api.gwt.serder.WebAppDataGwtSerDer().serialize( arg1);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.container.api.Ack>(handler) {
			@Override
			protected net.bluemind.core.container.api.Ack handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.container.api.gwt.serder.AckGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.webappdata.api.IWebAppDataPromise promiseApi() {
		return new WebAppDataEndpointPromise(this);
	}
}
