/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2024
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
*/
package net.bluemind.resource.service.event;

public enum BookingDecision {
	FREE("autoaccept"), //
	BUSY("autorefuse"), //
	OUT_OF_RANGE("autorefusedeadline"), //
	EXPIRED("");

	private final String decision;

	private BookingDecision(String decision) {
		this.decision = decision;
	}

	public String getDecision() {
		return decision;
	}

	public static BookingDecision fromDecision(String decision) {
		for (BookingDecision d : BookingDecision.values()) {
			if (d.decision.equals(decision)) {
				return d;
			}
		}
		return null;
	}

}
