/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2025
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.dto.settings;

import net.bluemind.eas.dto.settings.SettingsResponse.Oof.BodyType;

public class OofMessage {

	public final int enabled;
	public final String replyMessage;
	public final BodyType bodyType;
	public final Audience audience;

	public enum Audience {
		AppliesToInternal, AppliesToExternalKnown, AppliesToExternalUnknown
	}

	public OofMessage(int enabled, String replyMessage, BodyType bodyType, Audience audience) {
		this.enabled = enabled;
		this.replyMessage = replyMessage;
		this.bodyType = bodyType;
		this.audience = audience;
	}

	@Override
	public String toString() {
		return "OofMessage [audience=" + audience + ", replyMessage=" + replyMessage + ", enabled=" + enabled
				+ ", bodyType=" + bodyType + "]";
	}

}
