/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.user.api.IUserSettings.
 */
namespace net.bluemind.user.api
{

  public class UserSettingsClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public UserSettingsClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/users/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public Dictionary<String, String> get(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_settings";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Dictionary<String, String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public String getOne(String uid, String name )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/_setting/{name}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));
      methodPathValue = methodPathValue.Replace("{name}", HttpUtility.UrlEncode("" + name));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public void set(String uid, Dictionary<String, String> settings )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_settings";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = new JavaScriptSerializer().Serialize(settings);
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setOne(String uid, String name, String value )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_setting/{name}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));
      methodPathValue = methodPathValue.Replace("{name}", HttpUtility.UrlEncode("" + name));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, value);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
