/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.user.api
{
  [DataContract(Namespace="")]
  public partial class User : net.bluemind.directory.api.DirBaseValue  {
    [DataMember]
    public String login;
    
    [DataMember]
    public String password;
    
    [IgnoreDataMember]
    public System.DateTime? passwordLastChange;
    [DataMember(Name = "passwordLastChange")]
    public String passwordLastChangeSurrogate
    {
      get
      {
        return (passwordLastChange != null)
          ? "" + Math.Floor((((DateTime)passwordLastChange) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          passwordLastChange = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          passwordLastChange = null;
        }
      }
    }
    
    [DataMember]
    public Boolean passwordMustChange;
    
    [DataMember]
    public Boolean passwordNeverExpires;
    
    [DataMember]
    public net.bluemind.addressbook.api.VCard contactInfos = new net.bluemind.addressbook.api.VCard();
    
    [IgnoreDataMember]
    public net.bluemind.mailbox.api.MailboxRouting? routing;
    [DataMember(Name = "routing")]
    public String routingSurrogate
    {
        get
        {
            return routing.HasValue ? routing.ToString() : null;
        }
        set
        {
            net.bluemind.mailbox.api.MailboxRouting e;
            routing = Enum.TryParse(value, true, out e) ? e : (net.bluemind.mailbox.api.MailboxRouting?)null;
        }
    }
    
    [IgnoreDataMember]
    public net.bluemind.directory.api.BaseDirEntryAccountType? accountType;
    [DataMember(Name = "accountType")]
    public String accountTypeSurrogate
    {
        get
        {
            return accountType.HasValue ? accountType.ToString() : null;
        }
        set
        {
            net.bluemind.directory.api.BaseDirEntryAccountType e;
            accountType = Enum.TryParse(value, true, out e) ? e : (net.bluemind.directory.api.BaseDirEntryAccountType?)null;
        }
    }
    
    [DataMember]
    public Boolean loginCaps;
    
    [DataMember]
    public int? quota;
    
    [DataMember]
    public String mailboxCopyGuid;
    
    [IgnoreDataMember]
    public Dictionary<String, String> properties = new Dictionary<String, String>();
    [DataMember(Name = "properties")]
    private propertiesSerializer propertiesSurrogate
    {
        get
        {
            return new propertiesSerializer(properties);
        }
        set
        {
            properties = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class propertiesSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public propertiesSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public propertiesSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
  
  }
}
