/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.system.api
{
  [DataContract(Namespace="")]
  public partial class SubscriptionInformationsInstallationIndicator  {
    [IgnoreDataMember]
    public net.bluemind.system.api.SubscriptionInformationsInstallationIndicatorKind? kind;
    [DataMember(Name = "kind")]
    public String kindSurrogate
    {
        get
        {
            return kind.HasValue ? kind.ToString() : null;
        }
        set
        {
            net.bluemind.system.api.SubscriptionInformationsInstallationIndicatorKind e;
            kind = Enum.TryParse(value, true, out e) ? e : (net.bluemind.system.api.SubscriptionInformationsInstallationIndicatorKind?)null;
        }
    }
    
    [DataMember]
    public int? maxValue;
    
    [DataMember]
    public int? currentValue;
    
    [IgnoreDataMember]
    public System.DateTime? expiration;
    [DataMember(Name = "expiration")]
    public String expirationSurrogate
    {
      get
      {
        return (expiration != null)
          ? "" + Math.Floor((((DateTime)expiration) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          expiration = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          expiration = null;
        }
      }
    }
    
  
  }
}
