/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.system.api.IExternalSystem.
 */
namespace net.bluemind.system.api
{

  public class ExternalSystemClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public ExternalSystemClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/system/external";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public net.bluemind.system.api.ExternalSystem getExternalSystem(String systemIdentifier )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{systemIdentifier}";
      methodPathValue = methodPathValue.Replace("{systemIdentifier}", HttpUtility.UrlEncode("" + systemIdentifier));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.system.api.ExternalSystem>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.system.api.ExternalSystem> getExternalSystems()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.system.api.ExternalSystem>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.system.api.ExternalSystem> getExternalSystemsByAuthKind(List<net.bluemind.system.api.ExternalSystemAuthKind> authKinds )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_by_authkind";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.system.api.ExternalSystemAuthKind>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, authKinds);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.system.api.ExternalSystem>>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getLogo(String systemIdentifier )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{systemIdentifier}/_logo";
      methodPathValue = methodPathValue.Replace("{systemIdentifier}", HttpUtility.UrlEncode("" + systemIdentifier));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.system.api.ConnectionTestStatus testConnection(String systemIdentifier, net.bluemind.user.api.UserAccount account )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{systemIdentifier}/_test_connection";
      methodPathValue = methodPathValue.Replace("{systemIdentifier}", HttpUtility.UrlEncode("" + systemIdentifier));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.user.api.UserAccount));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, account);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.system.api.ConnectionTestStatus>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
