/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.system.api.ICredentials.
 */
namespace net.bluemind.system.api
{

  public class CredentialsClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public CredentialsClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/credentials/{domainUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public String addTotpCredential(net.bluemind.system.api.TotpCredential totpCredential )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/user/totp";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.system.api.TotpCredential));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, totpCredential);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<String>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential> getObfuscatedUserCredentials(String userUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/user/{userUid}";
      methodPathValue = methodPathValue.Replace("{userUid}", HttpUtility.UrlEncode("" + userUid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential> getSelfObfuscatedCredentials()
    {
      String methodVerb = "GET";
      String methodPathValue = "/user/_credentials/_self";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.api.ListResult<net.bluemind.system.api.Credential>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void removeSelfCredential(String credentialId )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/user/_credentials/{credentialId}/_self";
      methodPathValue = methodPathValue.Replace("{credentialId}", HttpUtility.UrlEncode("" + credentialId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void removeUserCredential(String userUid, String credentialId )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/user/{userUid}/{credentialId}";
      methodPathValue = methodPathValue.Replace("{userUid}", HttpUtility.UrlEncode("" + userUid));
      methodPathValue = methodPathValue.Replace("{credentialId}", HttpUtility.UrlEncode("" + credentialId));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public Boolean? validateTotpCredential(net.bluemind.system.api.TotpCredential totpCredential )
    {
      String methodVerb = "POST";
      String methodPathValue = "/user/totp/validate";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.system.api.TotpCredential));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, totpCredential);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<Boolean?>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
