/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.role.api
{
  [DataContract(Namespace="")]
  public partial class RoleDescriptor  {
    [DataMember]
    public String id;
    
    [DataMember]
    public String parentRoleId;
    
    [DataMember]
    public String categoryId;
    
    [DataMember]
    public String label;
    
    [DataMember]
    public String description;
    
    [DataMember]
    public Boolean selfPromote;
    
    [DataMember]
    public Boolean dirEntryPromote;
    
    [IgnoreDataMember]
    public net.bluemind.directory.api.BaseDirEntryKind? dirEntryKind;
    [DataMember(Name = "dirEntryKind")]
    public String dirEntryKindSurrogate
    {
        get
        {
            return dirEntryKind.HasValue ? dirEntryKind.ToString() : null;
        }
        set
        {
            net.bluemind.directory.api.BaseDirEntryKind e;
            dirEntryKind = Enum.TryParse(value, true, out e) ? e : (net.bluemind.directory.api.BaseDirEntryKind?)null;
        }
    }
    
    [DataMember]
    public String siblingRole;
    
    [DataMember]
    public List<String> childsRole = new List<String>();
    
    [DataMember]
    public Boolean visible;
    
    [DataMember]
    public Boolean delegable;
    
    [DataMember]
    public List<String> containerRoles = new List<String>();
    
    [DataMember]
    public int? priority;
    
  
  }
}
