/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.resource.api.type.IResourceTypes.
 */
namespace net.bluemind.resource.api.type
{

  public class ResourceTypesClient : BMClient
  {
    private String domainUid;
  
    /*
     * Constructor 
     */
    public ResourceTypesClient(String baseUrl, String sid , String domainUid )
    {
      this.baseUrl = baseUrl + "/api/resources/{domainUid}/type";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public void create(String identifier, net.bluemind.resource.api.type.ResourceTypeDescriptor resourceTypeDescriptor )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{identifier}";
      methodPathValue = methodPathValue.Replace("{identifier}", HttpUtility.UrlEncode("" + identifier));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.resource.api.type.ResourceTypeDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, resourceTypeDescriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.resource.api.type.ResourceTypeDescriptor get(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.resource.api.type.ResourceTypeDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public byte[] getIcon(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/icon";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<byte[]>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.resource.api.type.ResourceType> getTypes()
    {
      String methodVerb = "GET";
      String methodPathValue = "";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.resource.api.type.ResourceType>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setIcon(String uid, byte[] icon )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/icon";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = icon;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.resource.api.type.ResourceTypeDescriptor resourceTypeDescriptor )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.resource.api.type.ResourceTypeDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, resourceTypeDescriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
