/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.resource.api.type
{
  [DataContract(Namespace="")]
  public partial class ResourceTypeDescriptor  {
    [DataMember]
    public String label;
    
    [DataMember]
    public List<net.bluemind.resource.api.type.ResourceTypeDescriptorProperty> properties = new List<net.bluemind.resource.api.type.ResourceTypeDescriptorProperty>();
    
    [IgnoreDataMember]
    public Dictionary<String, String> templates = new Dictionary<String, String>();
    [DataMember(Name = "templates")]
    private templatesSerializer templatesSurrogate
    {
        get
        {
            return new templatesSerializer(templates);
        }
        set
        {
            templates = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class templatesSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public templatesSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public templatesSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
  
  }
}
