/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.mailbox.api.rules.conditions
{
  [DataContract(Namespace="")]
  public partial class MailFilterRuleFilterContains : net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilter  {
    [IgnoreDataMember]
    public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterContainsComparator? comparator;
    [DataMember(Name = "comparator")]
    public String comparatorSurrogate
    {
        get
        {
            return comparator.HasValue ? comparator.ToString() : null;
        }
        set
        {
            net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterContainsComparator e;
            comparator = Enum.TryParse(value, true, out e) ? e : (net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterContainsComparator?)null;
        }
    }
    
    [IgnoreDataMember]
    public net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterContainsModifier? modifier;
    [DataMember(Name = "modifier")]
    public String modifierSurrogate
    {
        get
        {
            return modifier.HasValue ? modifier.ToString() : null;
        }
        set
        {
            net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterContainsModifier e;
            modifier = Enum.TryParse(value, true, out e) ? e : (net.bluemind.mailbox.api.rules.conditions.MailFilterRuleFilterContainsModifier?)null;
        }
    }
    
    [DataMember]
    public List<String> values = new List<String>();
    
  
  }
}
