/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.icalendar.api
{
  [DataContract(Namespace="")]
  public partial class ICalendarElementAttendee  {
    [IgnoreDataMember]
    public net.bluemind.icalendar.api.ICalendarElementCUType? cutype;
    [DataMember(Name = "cutype")]
    public String cutypeSurrogate
    {
        get
        {
            return cutype.HasValue ? cutype.ToString() : null;
        }
        set
        {
            net.bluemind.icalendar.api.ICalendarElementCUType e;
            cutype = Enum.TryParse(value, true, out e) ? e : (net.bluemind.icalendar.api.ICalendarElementCUType?)null;
        }
    }
    
    [DataMember]
    public String member;
    
    [IgnoreDataMember]
    public net.bluemind.icalendar.api.ICalendarElementRole? role;
    [DataMember(Name = "role")]
    public String roleSurrogate
    {
        get
        {
            return role.HasValue ? role.ToString() : null;
        }
        set
        {
            net.bluemind.icalendar.api.ICalendarElementRole e;
            role = Enum.TryParse(value, true, out e) ? e : (net.bluemind.icalendar.api.ICalendarElementRole?)null;
        }
    }
    
    [IgnoreDataMember]
    public net.bluemind.icalendar.api.ICalendarElementParticipationStatus? partStatus;
    [DataMember(Name = "partStatus")]
    public String partStatusSurrogate
    {
        get
        {
            return partStatus.HasValue ? partStatus.ToString() : null;
        }
        set
        {
            net.bluemind.icalendar.api.ICalendarElementParticipationStatus e;
            partStatus = Enum.TryParse(value, true, out e) ? e : (net.bluemind.icalendar.api.ICalendarElementParticipationStatus?)null;
        }
    }
    
    [DataMember]
    public Boolean? rsvp;
    
    [DataMember]
    public String delTo;
    
    [DataMember]
    public String delFrom;
    
    [DataMember]
    public String sentBy;
    
    [DataMember]
    public String commonName;
    
    [DataMember]
    public String dir;
    
    [DataMember]
    public String lang;
    
    [DataMember]
    public String mailto;
    
    [DataMember]
    public String uri;
    
    [DataMember]
    public Boolean @internal;
    
    [DataMember]
    public String responseComment;
    
    [DataMember]
    public net.bluemind.core.api.date.BmDateTime counter = new net.bluemind.core.api.date.BmDateTime();
    
  
  }
}
