/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.icalendar.api
{
  [DataContract(Namespace="")]
  public partial class ICalendarElement  {
    [DataMember]
    public net.bluemind.core.api.date.BmDateTime dtstart = new net.bluemind.core.api.date.BmDateTime();
    
    [DataMember]
    public String summary;
    
    [IgnoreDataMember]
    public net.bluemind.icalendar.api.ICalendarElementClassification? classification;
    [DataMember(Name = "classification")]
    public String classificationSurrogate
    {
        get
        {
            return classification.HasValue ? classification.ToString() : null;
        }
        set
        {
            net.bluemind.icalendar.api.ICalendarElementClassification e;
            classification = Enum.TryParse(value, true, out e) ? e : (net.bluemind.icalendar.api.ICalendarElementClassification?)null;
        }
    }
    
    [DataMember]
    public String location;
    
    [DataMember]
    public String description;
    
    [DataMember]
    public int? priority;
    
    [DataMember]
    public List<net.bluemind.icalendar.api.ICalendarElementVAlarm> alarm = new List<net.bluemind.icalendar.api.ICalendarElementVAlarm>();
    
    [IgnoreDataMember]
    public net.bluemind.icalendar.api.ICalendarElementStatus? status;
    [DataMember(Name = "status")]
    public String statusSurrogate
    {
        get
        {
            return status.HasValue ? status.ToString() : null;
        }
        set
        {
            net.bluemind.icalendar.api.ICalendarElementStatus e;
            status = Enum.TryParse(value, true, out e) ? e : (net.bluemind.icalendar.api.ICalendarElementStatus?)null;
        }
    }
    
    [DataMember]
    public List<net.bluemind.icalendar.api.ICalendarElementAttendee> attendees = new List<net.bluemind.icalendar.api.ICalendarElementAttendee>();
    
    [DataMember]
    public net.bluemind.icalendar.api.ICalendarElementOrganizer organizer = new net.bluemind.icalendar.api.ICalendarElementOrganizer();
    
    [DataMember]
    public List<net.bluemind.tag.api.TagRef> categories = new List<net.bluemind.tag.api.TagRef>();
    
    [DataMember]
    public List<net.bluemind.core.api.date.BmDateTime> exdate = new List<net.bluemind.core.api.date.BmDateTime>();
    
    [DataMember]
    public List<net.bluemind.core.api.date.BmDateTime> rdate = new List<net.bluemind.core.api.date.BmDateTime>();
    
    [DataMember]
    public net.bluemind.icalendar.api.ICalendarElementRRule rrule = new net.bluemind.icalendar.api.ICalendarElementRRule();
    
    [DataMember]
    public String url;
    
    [DataMember]
    public String conference;
    
    [DataMember]
    public String conferenceId;
    
    [IgnoreDataMember]
    public Dictionary<String, String> conferenceConfiguration = new Dictionary<String, String>();
    [DataMember(Name = "conferenceConfiguration")]
    private conferenceConfigurationSerializer conferenceConfigurationSurrogate
    {
        get
        {
            return new conferenceConfigurationSerializer(conferenceConfiguration);
        }
        set
        {
            conferenceConfiguration = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class conferenceConfigurationSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public conferenceConfigurationSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public conferenceConfigurationSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [DataMember]
    public List<net.bluemind.attachment.api.AttachedFile> attachments = new List<net.bluemind.attachment.api.AttachedFile>();
    
    [IgnoreDataMember]
    public Dictionary<String, String> properties = new Dictionary<String, String>();
    [DataMember(Name = "properties")]
    private propertiesSerializer propertiesSurrogate
    {
        get
        {
            return new propertiesSerializer(properties);
        }
        set
        {
            properties = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class propertiesSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public propertiesSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public propertiesSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [DataMember]
    public int? sequence;
    
    [DataMember]
    public Boolean draft;
    
  
  }
}
