/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.eas.api
{
  [DataContract(Namespace="")]
  public partial class FolderSyncVersions  {
    [DataMember]
    public net.bluemind.eas.api.Account account = new net.bluemind.eas.api.Account();
    
    [IgnoreDataMember]
    public Dictionary<String, String> versions = new Dictionary<String, String>();
    [DataMember(Name = "versions")]
    private versionsSerializer versionsSurrogate
    {
        get
        {
            return new versionsSerializer(versions);
        }
        set
        {
            versions = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class versionsSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public versionsSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public versionsSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
  
  }
}
