/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.domain.api.IDomainSettings.
 */
namespace net.bluemind.domain.api
{

  public class DomainSettingsClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public DomainSettingsClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/domains/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public Dictionary<String, String> get()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_settings";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Dictionary<String, String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void set(Dictionary<String, String> settings )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_settings";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = new JavaScriptSerializer().Serialize(settings);
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
