/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.domain.api
{
  [DataContract(Namespace="")]
  public partial class Domain  {
    [DataMember]
    public String label;
    
    [DataMember]
    public String name;
    
    [DataMember]
    public String description;
    
    [IgnoreDataMember]
    public Dictionary<String, String> properties = new Dictionary<String, String>();
    [DataMember(Name = "properties")]
    private propertiesSerializer propertiesSurrogate
    {
        get
        {
            return new propertiesSerializer(properties);
        }
        set
        {
            properties = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class propertiesSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public propertiesSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public propertiesSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [DataMember]
    public Boolean global;
    
    [DataMember]
    public List<String> aliases = new List<String>();
    
    [DataMember]
    public String defaultAlias;
    
  
  }
}
