/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.cti.api.IComputerTelephonyIntegration.
 */
namespace net.bluemind.cti.api
{

  public class ComputerTelephonyIntegrationClient : BMClient
  {
    private String domainUid;
    private String userUid;
  
    /*
     * Constructor 
     */
    public ComputerTelephonyIntegrationClient(String baseUrl, String sid , String domainUid , String userUid )
    {
      this.baseUrl = baseUrl + "/api/cti/{domainUid}/{userUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.userUid = userUid;
      this.baseUrl = this.baseUrl.Replace("{userUid}", userUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public void dial(String number )
    {
      String methodVerb = "POST";
      String methodPathValue = "/dial";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("number", number.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void forward(String component, String phoneNumber )
    {
      String methodVerb = "POST";
      String methodPathValue = "/forward/{component}";
      methodPathValue = methodPathValue.Replace("{component}", HttpUtility.UrlEncode("" + component));

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("phoneNumber", phoneNumber.ToString());

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.cti.api.Status getStatus()
    {
      String methodVerb = "GET";
      String methodPathValue = "/status";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.cti.api.Status>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> getUserEmails()
    {
      String methodVerb = "GET";
      String methodPathValue = "/users";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setStatus(String component, net.bluemind.cti.api.Status status )
    {
      String methodVerb = "POST";
      String methodPathValue = "/status/{component}";
      methodPathValue = methodPathValue.Replace("{component}", HttpUtility.UrlEncode("" + component));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.cti.api.Status));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, status);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
