/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.core.container.model
{
  [DataContract(Namespace="")]
  public partial class ItemFlagFilter  {
    [IgnoreDataMember]
    public List<net.bluemind.core.container.model.ItemFlag> must = new List<net.bluemind.core.container.model.ItemFlag>();
    [DataMember(Name = "must")]
    public List<String> mustSurrogate
    {
        get
        {
            return must == null ? null : must.Select(v => v.ToString()).ToList();
        }
        set
        {
            must = new List<net.bluemind.core.container.model.ItemFlag>();
            foreach (string s in value)
            {
                net.bluemind.core.container.model.ItemFlag e;
                if (Enum.TryParse(s, true, out e))
                {
                    must.Add(e);
                }
            }            
        }
    }
    
    [IgnoreDataMember]
    public List<net.bluemind.core.container.model.ItemFlag> mustNot = new List<net.bluemind.core.container.model.ItemFlag>();
    [DataMember(Name = "mustNot")]
    public List<String> mustNotSurrogate
    {
        get
        {
            return mustNot == null ? null : mustNot.Select(v => v.ToString()).ToList();
        }
        set
        {
            mustNot = new List<net.bluemind.core.container.model.ItemFlag>();
            foreach (string s in value)
            {
                net.bluemind.core.container.model.ItemFlag e;
                if (Enum.TryParse(s, true, out e))
                {
                    mustNot.Add(e);
                }
            }            
        }
    }
    
    [DataMember]
    public List<long?> skipVersions = new List<long?>();
    
    [DataMember]
    public Boolean skipExpunged;
    
  
  }
}
