/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.core.container.model
{
  [DataContract(Namespace="")]
  public partial class ContainerSyncStatus  {
    [IgnoreDataMember]
    public Dictionary<String, String> syncTokens = new Dictionary<String, String>();
    [DataMember(Name = "syncTokens")]
    private syncTokensSerializer syncTokensSurrogate
    {
        get
        {
            return new syncTokensSerializer(syncTokens);
        }
        set
        {
            syncTokens = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class syncTokensSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public syncTokensSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public syncTokensSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [DataMember]
    public long? nextSync;
    
    [IgnoreDataMember]
    public System.DateTime? lastSync;
    [DataMember(Name = "lastSync")]
    public String lastSyncSurrogate
    {
      get
      {
        return (lastSync != null)
          ? "" + Math.Floor((((DateTime)lastSync) -
           new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc)).TotalMilliseconds)
          : null;
      }
      set
      {
        try
        {
          var time0 = new DateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeKind.Utc);
          lastSync = !String.IsNullOrEmpty(value)
            ? time0.AddMilliseconds(double.Parse(value)).ToLocalTime()
            : (DateTime?) null;
        }
        catch (Exception)
        {
          lastSync = null;
        }
      }
    }
    
    [IgnoreDataMember]
    public net.bluemind.core.container.model.ContainerSyncStatusStatus? syncStatus;
    [DataMember(Name = "syncStatus")]
    public String syncStatusSurrogate
    {
        get
        {
            return syncStatus.HasValue ? syncStatus.ToString() : null;
        }
        set
        {
            net.bluemind.core.container.model.ContainerSyncStatusStatus e;
            syncStatus = Enum.TryParse(value, true, out e) ? e : (net.bluemind.core.container.model.ContainerSyncStatusStatus?)null;
        }
    }
    
    [DataMember]
    public String syncStatusInfo;
    
  
  }
}
