/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.container.api.IOwnerSubscriptions.
 */
namespace net.bluemind.core.container.api
{

  public class OwnerSubscriptionsClient : BMClient
  {
    private String domainUid;
    private String ownerUid;
  
    /*
     * Constructor 
     */
    public OwnerSubscriptionsClient(String baseUrl, String sid , String domainUid , String ownerUid )
    {
      this.baseUrl = baseUrl + "/api/containers/_subscriptions/{domainUid}/{ownerUid}";      
      this.sid = sid;
      this.domainUid = domainUid;
      this.baseUrl = this.baseUrl.Replace("{domainUid}", domainUid);
      this.ownerUid = ownerUid;
      this.baseUrl = this.baseUrl.Replace("{ownerUid}", ownerUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public net.bluemind.core.container.model.ContainerChangeset<String> changeset(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changeset";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<long?> changesetById(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_changesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<long?>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion> filteredChangesetById(long? since, net.bluemind.core.container.model.ItemFlagFilter filter )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_filteredChangesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ItemFlagFilter));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, filter);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemVersion>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier> fullChangesetById(long? since )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_fullChangesetById";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("since", since.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerChangeset<net.bluemind.core.container.model.ItemIdentifier>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel> getComplete(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}/complete";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel> getCompleteById(long? id )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{id}/completeById";
      methodPathValue = methodPathValue.Replace("{id}", HttpUtility.UrlEncode("" + id));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> getMultiple(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public long? getVersion()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_version";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<long?>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> list()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_list";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>> multipleGetById(List<long?> ids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mgetById";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<long?>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, ids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemValue<net.bluemind.core.container.api.ContainerSubscriptionModel>>>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
