/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.container.api.IContainers.
 */
namespace net.bluemind.core.container.api
{

  public class ContainersClient : BMClient
  {
  
    /*
     * Constructor 
     */
    public ContainersClient(String baseUrl, String sid )
    {
      this.baseUrl = baseUrl + "/api/containers/_manage";      
      this.sid = sid;
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public List<net.bluemind.core.container.model.ContainerDescriptor> all(net.bluemind.core.container.api.ContainerQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_list";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.api.ContainerQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ContainerDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ContainerDescriptor> allForUser(String domainUid, String userUid, net.bluemind.core.container.api.ContainerQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_listforuser";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("domainUid", domainUid.ToString());
      queryParams.Add("userUid", userUid.ToString());

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.api.ContainerQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ContainerDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.BaseContainerDescriptor> allLight(net.bluemind.core.container.api.ContainerQuery query )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_listLight";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.api.ContainerQuery));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, query);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.BaseContainerDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.BaseContainerDescriptor create(String uid, net.bluemind.core.container.model.ContainerDescriptor descriptor )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ContainerDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, descriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.model.BaseContainerDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public void delete(String uid )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public Boolean exists(String containerUid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_exists";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, containerUid);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<Boolean>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerDescriptor get(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public Dictionary<String, List<net.bluemind.core.container.model.acl.AccessControlEntry>> getAccessControlLists(List<String> containerIds )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_macl";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, containerIds);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<Dictionary<String, List<net.bluemind.core.container.model.acl.AccessControlEntry>>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ContainerDescriptor> getContainers(List<String> containerIds )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, containerIds);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ContainerDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.BaseContainerDescriptor> getContainersLight(List<String> containerIds )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mgetLight";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, containerIds);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.BaseContainerDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerDescriptor getForUser(String domainUid, String userUid, String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_forUser";

      NameValueCollection queryParams = new NameValueCollection();
      queryParams.Add("domainUid", domainUid.ToString());
      queryParams.Add("userUid", userUid.ToString());
      queryParams.Add("uid", uid.ToString());

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerDescriptor getIfPresent(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_ifPresent/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.BaseContainerDescriptor getLight(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_light/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.BaseContainerDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.BaseContainerDescriptor getLightIfPresent(String uid )
    {
      String methodVerb = "GET";
      String methodPathValue = "/_ifPresentLight/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.BaseContainerDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setAccessControlList(String uid, List<net.bluemind.core.container.model.acl.AccessControlEntry> entries )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}/_acl";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.core.container.model.acl.AccessControlEntry>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, entries);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(String uid, net.bluemind.core.container.model.ContainerModifiableDescriptor descriptor )
    {
      String methodVerb = "POST";
      String methodPathValue = "/{uid}";
      methodPathValue = methodPathValue.Replace("{uid}", HttpUtility.UrlEncode("" + uid));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ContainerModifiableDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, descriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
