/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.IO;
using System.Net;
using System.Web;
using System.Collections.Generic;
using System.Collections.Specialized;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Web.Script.Serialization;
using core2client;

/**
 * Implementation of net.bluemind.core.container.api.IContainerManagement.
 */
namespace net.bluemind.core.container.api
{

  public class ContainerManagementClient : BMClient
  {
    private String containerUid;
  
    /*
     * Constructor 
     */
    public ContainerManagementClient(String baseUrl, String sid , String containerUid )
    {
      this.baseUrl = baseUrl + "/api/containers/_manage/{containerUid}";      
      this.sid = sid;
      this.containerUid = containerUid;
      this.baseUrl = this.baseUrl.Replace("{containerUid}", containerUid);
      this.logger = new DefaultLogger();
      this.version = "5.5.3184";
    }
    
    public void allowOfflineSync(String subject )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/{subject}/offlineSync";
      methodPathValue = methodPathValue.Replace("{subject}", HttpUtility.UrlEncode("" + subject));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public Boolean canAccess(List<String> verbsOrRoles )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_canAccess";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, verbsOrRoles);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<Boolean>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.PermittedVerbs canAccessVerbs(List<String> verbsOrRoles )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_canAccessVerbs";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, verbsOrRoles);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<net.bluemind.core.container.api.PermittedVerbs>(methodPathValue, queryParams, body, methodVerb);
    }
    public void disallowOfflineSync(String subject )
    {
      String methodVerb = "DELETE";
      String methodPathValue = "/{subject}/offlineSync";
      methodPathValue = methodPathValue.Replace("{subject}", HttpUtility.UrlEncode("" + subject));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.acl.AccessControlEntry> getAccessControlList()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_acl";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.acl.AccessControlEntry>>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemDescriptor> getAllItems()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_list";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<net.bluemind.core.container.model.ItemDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.model.ContainerDescriptor getDescriptor()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_descriptor";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.model.ContainerDescriptor>(methodPathValue, queryParams, body, methodVerb);
    }
    public net.bluemind.core.container.api.Count getItemCount()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_itemCount";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<net.bluemind.core.container.api.Count>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<net.bluemind.core.container.model.ItemDescriptor> getItems(List<String> uids )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_mget";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<String>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, uids);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      return this.execute<List<net.bluemind.core.container.model.ItemDescriptor>>(methodPathValue, queryParams, body, methodVerb);
    }
    public Dictionary<String, String> getSettings()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_settings";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<Dictionary<String, String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setAccessControlList(List<net.bluemind.core.container.model.acl.AccessControlEntry> entries )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_acl";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(List<net.bluemind.core.container.model.acl.AccessControlEntry>));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, entries);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setPersonalSettings(Dictionary<String, String> settings )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_personalSettings";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = new JavaScriptSerializer().Serialize(settings);
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setSetting(String key, String value )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_settings/{key}";
      methodPathValue = methodPathValue.Replace("{key}", HttpUtility.UrlEncode("" + key));

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(String));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, value);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public void setSettings(Dictionary<String, String> settings )
    {
      String methodVerb = "PUT";
      String methodPathValue = "/_settings";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      body = new JavaScriptSerializer().Serialize(settings);
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
    public List<String> subscribers()
    {
      String methodVerb = "GET";
      String methodPathValue = "/_subscription";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      return this.execute<List<String>>(methodPathValue, queryParams, body, methodVerb);
    }
    public void update(net.bluemind.core.container.model.ContainerModifiableDescriptor descriptor )
    {
      String methodVerb = "POST";
      String methodPathValue = "/_descriptor";

      NameValueCollection queryParams = new NameValueCollection();

      dynamic body = null;
      var dcs = new DataContractJsonSerializer(typeof(net.bluemind.core.container.model.ContainerModifiableDescriptor));
      using (var ms = new MemoryStream())
      {
        dcs.WriteObject(ms, descriptor);
        body = Encoding.UTF8.GetString(ms.ToArray());
      }
      this.execute<object>(methodPathValue, queryParams, body, methodVerb);
    }
  
  }
  
}
