/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;

namespace net.bluemind.calendar.api
{
  [DataContract(Namespace="")]
  public partial class VEventSeries  {
    [DataMember]
    public net.bluemind.calendar.api.VEvent main = new net.bluemind.calendar.api.VEvent();
    
    [DataMember]
    public List<net.bluemind.calendar.api.VEventOccurrence> occurrences = new List<net.bluemind.calendar.api.VEventOccurrence>();
    
    [DataMember]
    public List<net.bluemind.calendar.api.VEventCounter> counters = new List<net.bluemind.calendar.api.VEventCounter>();
    
    [IgnoreDataMember]
    public Dictionary<String, String> properties = new Dictionary<String, String>();
    [DataMember(Name = "properties")]
    private propertiesSerializer propertiesSurrogate
    {
        get
        {
            return new propertiesSerializer(properties);
        }
        set
        {
            properties = value != null ? value._data : null;
        }
    }
    [Serializable]
    private class propertiesSerializer : ISerializable
    {
        public Dictionary<String, String> _data;
        public propertiesSerializer(Dictionary<String, String> dict)
        {
            _data = dict;
        }
        public propertiesSerializer(SerializationInfo info, StreamingContext context)
        {
            _data = new Dictionary<String, String>();
            var valueEnum = info.GetEnumerator();
            while (valueEnum.MoveNext())
            {
                _data[valueEnum.Current.Name] = (String) valueEnum.Current.Value;
            }
        }
        public void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            if (_data == null) return;
            foreach (var pair in _data)
            {
                info.AddValue(pair.Key, pair.Value);
            }
        }
    }
    
    [DataMember]
    public String icsUid;
    
    [DataMember]
    public Boolean acceptCounters;
    
  
  }
}
